<?php
defined('PF_VERSION') OR exit('Access denied');
define('PLUGIN_MENU', __('Menu', 'menu'));

class Menu_Plugin extends Pf_Plugin {

    public $name = PLUGIN_MENU;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the Menu description';

    public function activate() {
        $db = Pf::database();
        $count = $db->dcount('id', 'pf_options', "`option_name`='menu'");
        if ($count == 0) {
            $sql = "INSERT INTO `pf_options` ( `option_name`, `option_value`) VALUES ('menu', '')";
            $db->query($sql);
        }
    }
    public function deactivate() {

    }
    public function admin_init() {
        if (is_admin())
        $this->admin_menu('fa fa-tasks', __('Menu', 'menu'), 'menu', 'plugin_menu');
    }
    public function public_init(){
        $shortcode = Pf::shortcode();
        $shortcode->add( 'menu', array($this,'public_menu' ));
    }
    
    function public_menu( $atts, $content = null, $code = '' ){
       $menuid  =   !empty($atts['id'])?$atts['id']:'';
       $type    =   !empty($atts['type'])?$atts['type']:'';
        ob_start();
        require abs_plugin_path(__FILE__) . "/menu/public/menu-public.php";
        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }
    function plugin_menu() {
        if (is_admin()) {
            $action = isset($_GET ['act']) ? $_GET ['act'] : 'main';
            $a_act = array(
                'once',
                'edit',
                'main'
            );
            $this->js('media/assets/fancybox/jquery.fancybox-1.3.6.pack.js',__FILE__);
            $this->css('media/assets/fancybox/jquery.fancybox-1.3.6.css',__FILE__);
            $this->css('admin/themes/default/assets/bootstrap-modal/css/animate.min.css');
            $this->js('admin/themes/default/assets/bootstrap-modal/js/jquery/jquery.easing.1.3.js');
            $this->js('admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js');
            $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );
            $this->css('menu/assets/style.css', __FILE__);
            admin_js('admin/plugins/menu/assets/js.js');
            require_once abs_plugin_path(__FILE__) . "/menu/class/menu-class.php";
            require_once abs_plugin_path(__FILE__) . "/menu/action/" . $action . ".php";
        }
        else
            echo __('Access Denied!','menu');
    }

}
